require( "scripts/style.lua" );

HeaderFont = {
  bigButtonFont,
  50,
  GoldColor
};

GameModeFont = {
  standardFont,
  38,
  DarkRedColor
};

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

EligibleFont = {
  standardFont,
  18,
  BlackColor
};

EligibleAsteriskFont = {
  standardFont,
  12,
  BlackColor
};


ConnectingToServerFont = {
    standardFont,
    26,
    BlackColor
};

TableHeaderFont = {
  standardFont,
  30,
  BlackColor
};

ScoreInfoFont = {
  standardFont,
  18,
  BlackColor
};


ScoreFont = {
  standardFont,
  18,
  BlackColor
};

RankFont = {
  standardFont,
  26,
  BlackColor
};

LeftButtonGraphics = {
    "buttons/arrowleft_up",
    "buttons/arrowleft_down",
    "buttons/arrowleft_over"
};

kScoreRowSpace = 22;
kRowY = 65;
kNumberX = 45;
kNameX = 65;
kScoreX = 370;
kP1X = kNumberX + 1;

kNameW = 186;
kNameH = 21;

eLocalView=0;
eRequestingCategories=1;
eRequestingScores=2;
eSubmitting=3;
eGlobalView=4;
eError=5;

function UpdateButtons()
    local state = GetState();
    local localHS = IsEnabled(kHiscoreLocalOnly);
    local anonHS = IsEnabled(kHiscoreAnonymous);
    local fullHS = (not localHS) and (not anonHS);

    EnableWindow("view",false);
    EnableWindow("viewlocal",false);
    EnableWindow("submit",false);
    EnableWindow("categoryleft",false);
    EnableWindow("categoryright",false);
    
    if (state==eLocalView) then
        local eligibleScore;

        if fullHS then
            EnableWindow("moreinfo",true);
        else 
            EnableWindow("moreinfo",false);
        end
        
        if not localHS then
            EnableWindow("view",true);

            if (ScoreAvailable()) then
                EnableWindow("submit",true);
            end
        end
    elseif (state == eGlobalView) then
        EnableWindow("viewlocal",true);
        EnableWindow("categoryleft",true);
        EnableWindow("categoryright",true);
    elseif (state == eError) then
        EnableWindow("viewlocal",true);
    end
end


MakeDialog
{
    -- Name the modal dialog
    name="hiscorescreen",
    Bitmap
    {
        image="backgrounds/loading",

        HiscoreWindow
        {
            x=0,y=0,h=kMax,w=kMax,
            alpha_shadow = 0.5;
            Bitmap
            {
                name="grayimage",
                image="backgrounds/shadow.png",
                alpha=true,
                x=0,
                y=0,
            },
            Bitmap
            {
                name="main_panel",
                image="hiscore/hs.png",
                x=0,
                y=12,
            },

            Text
            {
                font = HeaderFont,
                name = "header",
                x=20,y=40,w=kMax,h=kMax,
                flags = kHAlignCenter + kVAlignTop,
                label = "highscoreheader"
            };

            Text
            {
                font = GameModeFont,
                name = "gamemode",
                x=20,y=92,w=kMax,h=kMax,
                flags = kHAlignCenter + kVAlignTop,
                label = "#GAMEMODE"
            };

            Window --Bitmap
            {
                x = 90,
                y = 150,
                w = 400,
                h = 303,
                --image="hiscore/global-hs-bb_large",
                name="leftpanel",

                Text
                {
                    font = TableHeaderFont,
                    name = "local",
                    x=0,y=2,w=345,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "localhighscores"
                };


                Text
                {
                    font = TableHeaderFont,
                    name = "global",
                    x=0,y=2,w=345,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "globalhighscores"
                };

                Text
                {
                    font = TableHeaderFont,
                    name = "topplayers",
                    x=0,y=2,w=264,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "topplayers"
                };

                Text
                {
                    font = ScoreFont,
                    name = "1",
                    x=0,y=kRowY,w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "1."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_1",
                    x=kP1X,y=kRowY
                };

                Text
                {
                    font = ScoreFont,
                    name = "name1",
                    x=kNameX,y=kRowY,w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score1",
                    x=0,y=kRowY,w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "2",
                    x=0,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "2."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_2",
                    x=kP1X,y=kRowY+(1*kScoreRowSpace)
                };


                Text
                {
                    font = ScoreFont,
                    name = "name2",
                    x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score2",
                    x=0,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "3",
                    x=0,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "3."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_3",
                    x=kP1X,y=kRowY+(2*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name3",
                    x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score3",
                    x=0,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "4",
                    x=0,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "4."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_4",
                    x=kP1X,y=kRowY+(3*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name4",
                    x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score4",
                    x=0,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "5",
                    x=0,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "5."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_5",
                    x=kP1X,y=kRowY+(4*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name5",
                    x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score5",
                    x=0,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "6",
                    x=0,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "6."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_6",
                    x=kP1X,y=kRowY+(5*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name6",
                    x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score6",
                    x=0,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "7",
                    x=0,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "7."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_7",
                    x=kP1X,y=kRowY+(6*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name7",
                    x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score7",
                    x=0,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "8",
                    x=0,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "8."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_8",
                    x=kP1X,y=kRowY+(7*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name8",
                    x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score8",
                    x=0,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "9",
                    x=0,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "9."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_9",
                    x=kP1X,y=kRowY+(8*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name9",
                    x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score9",
                    x=0,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    font = ScoreFont,
                    name = "10",
                    x=0,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "10."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_10",
                    x=kP1X,y=kRowY+(9*kScoreRowSpace)
                };

                Text
                {
                    font = ScoreFont,
                    name = "name10",
                    x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    font = ScoreFont,
                    name = "score10",
                    x=0,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

            };

            Window --Bitmap
            {
                x = 520,
                y = 150,
                w = 206,
                h = 289,
                --image="hiscore/local-hs-bb",
                name="rightpanelsmall",

                Text
                {
                    font = ScoreInfoFont,
                    name = "yourrankglobalinfo",
                    x=40,y=0,w=kMax-40,h=kMax,
                    flags = kHAlignCenter + kVAlignCenter,
                    label = "globalhighscoreinfo"
                };

                Text
                {
                    font = RankFont,
                    name = "yourrank",
                    x=10,y=3,w=kMax-10,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "yourrank"
                };

                Text
                {
                    font = RankFont,
                    name = "congratulations",
                    x=10,y=50,w=kMax-10,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "congratshighscore"
                };

                Text
                {
                    font = RankFont,
                    name = "dnq",
                    x=10,y=50,w=kMax-10,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "scorednq"
                };
            },


            Window --Bitmap
            {
                x = 520, --480
                y = 150,
                w = 206,
                h = 289,
                --image="hiscore/local-hs-bb",
                name="rightpanel",

                Text
                {
                    font = TableHeaderFont,
                    name = "globalinfoheader",
                    x=0,y=2,w=kMax,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "globalhighscores"
                };

                Text
                {
                    font = ScoreInfoFont,
                    name = "info",
                    x=10,y=55,w=kMax-10,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "globalhighscoreinfo"
                };


                Text
                {
                    font = EligibleFont,
                    name = "eligible",
                    x=10,y=140,w=kMax-10,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "eligible"
                };

                SetStyle(ButtonStyle),
                Button
                {
                    x=kCenter,
                    y=kMax-110,
                    graphics = StButtonGraphicsMid,
                    name="moreinfo",
                    label="moreinfo",
                    font = MenuButtonFont;
                    command =
                        function()
                            DoModal("scripts/hiscoreinfo.lua");
                        end

                };

                Button
                {
                    x=kCenter,
                    y=kMax-55,
                    name="submit",
                    label="submit",
                    graphics = StButtonGraphicsMid,
                    font = MenuButtonFont;
                };
            };

--[[
            Text
            {
                font = EligibleAsteriskFont,
                name = "eligibleasterisk",
                x=490,y=510,w=kMax-20,h=kMax,
                flags = kHAlignLeft + kVAlignTop,
                label = "eligibleasterisk",
                padding=0
            };
--]]


            Text
            {
                font = ConnectingToServerFont,
                name = "server",
                x=520,y=240,w=200,h=130,
                flags = kHAlignCenter + kVAlignCenter,
                label = "connectingtoserver"
            };

            Text
            {
                font = ConnectingToServerFont,
                name = "error",
                x=520,y=240,w=200,h=130,
                flags = kHAlignCenter + kVAlignCenter,
            };



            Text
            {
                font = ScoreFont,
                name = "category",
                x=163,y=194,w=208,h=40,
                flags = kHAlignCenter + kVAlignTop,
            };

            SetStyle(ButtonStyle),

            Button
            {
                graphics = LeftButtonGraphics,
                name="gamemodeleft",
                x=232,
                y=100,
            };

            Button
            {
                graphics = LeftButtonGraphics,
                name="gamemoderight",
                x=558,
                y=100,
                hflip=true,
            };

            Button
            {
                graphics = LeftButtonGraphics,
                name="categoryleft",
                x=172,
                y=197,
                scale = 0.8
            };

            Button
            {
                graphics = LeftButtonGraphics,
                name="categoryright",
                x=338,
                y=197,
                scale = 0.8,
                hflip=true,
            };

            Button
            {
                graphics = LeftButtonGraphics,
                rotate=true,
                name="scrollup",
                x=463,
                y=215,
                scale = 0.6
            };

            Button
            {
                graphics = LeftButtonGraphics,
                rotate=true,
                hflip=true,
                name="scrolldown",
                x=463,
                y=415,
                scale = 0.6
            };

            Button
            {
                x=44,
                y=536, --kMax-50,
                name="back",
                graphics = StButtonGraphicsSm,
                font = MenuButtonFont;
                type = kPush,
                flags = kHAlignCenter + kVAlignCenter,
                label="back",
                command =
                    function()
                        PopModal("hiscorescreen"); -- take off high score menu, restart game loop
                    end
            };
			--[[
            Button
            {
                x=205,
                y=536, --kMax-50,
                name="policy",
                type = kPush,
                font = MenuButtonFont;
                graphics = StButtonGraphicsMidBig,
                flags = kHAlignCenter + kVAlignCenter,
                label="btn_policy",
                command =
                    function()
                        if (IsEnabled(kHiscoreAnonymous)) then
                            DisplayDialog { 
                                "scripts/ok.lua", 
                                body ="privacy_anon",
                                title = ""
                            };
                        else
                            LaunchPrivacyPolicy();
                        end
                    end
            };
	--]]
            SetStyle(LongButtonStyle),
            Button
            {
                --align=kHAlignRight, -- Position this button at its right edge
                x=434,  -- -20 With above align, position the right edge
                y=536,
                font = MenuButtonFont;
                graphics = StButtonGraphicsBig,
                name="viewlocal",
                label="viewlocal",
            };
            Button
            {
                x=434,
                y=536,
                font = MenuButtonFont;
                graphics = StButtonGraphicsBig,
                name="view",
                label="viewglobal",
            };


        }
    }
}